/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	WorldMap
**
** DESCRIPTION:	World map
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef WORLD_MAP_H
#define WORLD_MAP_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
static const char *WorldMap_sc_sFileNamePrefix = "Map";
const int WorldMap_c_iBlockWidth = 512;
const int WorldMap_c_iBlockHeight = 512;
const int WorldMap_c_iWidthInBlocks = 4;
const int WorldMap_c_iHeightInBlocks = 4;
const int WorldMap_c_iWidth = WorldMap_c_iBlockWidth * WorldMap_c_iWidthInBlocks;
const int WorldMap_c_iHeight = WorldMap_c_iBlockHeight * WorldMap_c_iHeightInBlocks;
const int WorldMap_c_iNumBlocks = WorldMap_c_iWidthInBlocks * WorldMap_c_iHeightInBlocks;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CWorldMap
{
private:

	//class structures
	struct SBlock
	{
		ldwImage *		m_pImage;
		int				m_iXPos;
		int				m_iYPos;
	};

	//class data
	SBlock				m_Block[WorldMap_c_iNumBlocks];

	//class methods
	//setup
	public:		CWorldMap();
	public:		~CWorldMap();
	public:		void LoadAssets();
	public:		void ReleaseAssets();

	//process
	public:		void Draw(const ldwPoint sTopLeft, ldwRect sWindow) const;

	//access
	public:		const bool IsOnMap(const ldwPoint sPos) const;
	public:		const ldwPoint RandomPoint() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CWorldMap		WorldMap;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/
